/*
   2x Res-CRT Shader
   
   Copyright (C) 2020 guest(r) - guest.r@gmail.com

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

uniform sampler2D sampler0;
varying vec2 v_position;
uniform vec2 u_texelDelta;
uniform vec2 u_pixelDelta;

#define bloom        0.40     // bloom intensity (from 0.0 to 1.0)        

#define h_sharp      1.50     // pixel sharpness (from 1.0 to 10.0)
#define s_sharp      0.00     // substractive sharpness (from 0.0 to 1.0)

#define masksize     1.00     // Mask Size (1.0 or 2.0 (2.0 for 4k))
#define slotmask     0.65     // Slot Mask Strength (from 0.0 to 1.0)
#define slotwidth    2.00     // Slot Mask Width  (from 1.0 to 4.0)
#define double_slot  1.00     // Slot Mask Height  (1.0 or 2.0)
#define slotms       1.00     // Slot Mask Size  (1.0 or 2.0)
#define mcut         0.20     // Mask 5&6 cutoff (0.0 to 0.5)
#define maskDark     0.20     // Dark "Phosphor"  (0.0 to 1.0)
#define maskLight    1.00     // Light "Phosphor"  (1.0 to 2.0)

#define brightboost1  1.40     // adjust brightness dark pixels
#define brightboost2  1.00     // adjust brightness bright pixels

vec3 Mask(vec2 pos, vec3 c)
{
	pos = floor(pos/masksize);
	vec3 mask = vec3(maskDark, maskDark, maskDark);
	
	float mx = max(max(c.r,c.g),c.b);
	vec3 maskTmp = vec3( min( 1.25*max(mx-mcut,0.0)/(1.0-mcut) ,maskDark + 0.2*(1.0-maskDark)*mx));
	float adj = 0.80*maskLight - 0.5*(0.80*maskLight - 1.0)*mx + 0.75*(1.0-mx);	
	mask = maskTmp;
	pos.x = fract(pos.x/2.0);
	if  (pos.x < 0.5)
	{	mask.r  = adj;
		mask.b  = adj;
	}
	else     mask.g = adj;
	return mask;
} 
 

float SlotMask(vec2 pos, vec3 c)
{
	if (slotmask == 0.0) return 1.0;
	
	pos = floor(pos/slotms);
	float mx = pow(max(max(c.r,c.g),c.b),1.33);
	float mlen = slotwidth*2.0;
	float px = fract(pos.x/mlen);
	float py = floor(fract(pos.y/(2.0*double_slot))*2.0*double_slot);
	float slot_dark = mix(1.0-slotmask, 1.0-0.80*slotmask, mx);
	float slot = 1.0 + 0.7*slotmask*(1.0-mx);
	if (py == 0.0 && px <  0.5) slot = slot_dark; else
	if (py == double_slot && px >= 0.5) slot = slot_dark;		
	
	return slot;
}    



void main() 
{
	// Calculating texel coordinates

	vec2 tex = v_position * 1.00001;

	vec2 size     = 1.0 / u_texelDelta;
	vec2 inv_size = u_texelDelta;

	vec2 OGL2Pos = tex * size - vec2(0.5, 0.0);
	vec2 OGL2bPos = (tex + 0.000001) * (1.0/u_pixelDelta.xy);
	vec2 fp = fract(OGL2Pos);
	vec2 dx = vec2(inv_size.x,0.0); vec2 x2 = dx + dx;
	vec2 dy = vec2(0.0, inv_size.y);
	float fpx = fp.x;
	float f = fp.y;

	vec2 pC4 = floor(OGL2Pos) * inv_size + 0.5*inv_size;	

	float zero = exp2(-h_sharp);   
	float sharp1 = s_sharp * zero;
	
	float wl3 = 2.0 + fpx;
	float wl2 = 1.0 + fpx;
	float wl1 =       fpx;
	float wr1 = 1.0 - fpx;
	float wr2 = 2.0 - fpx;
	float wr3 = 3.0 - fpx;

	wl3*=wl3; wl3 = exp2(-h_sharp*wl3);	
	wl2*=wl2; wl2 = exp2(-h_sharp*wl2);
	wl1*=wl1; wl1 = exp2(-h_sharp*wl1);
	wr1*=wr1; wr1 = exp2(-h_sharp*wr1);
	wr2*=wr2; wr2 = exp2(-h_sharp*wr2);
	wr3*=wr3; wr3 = exp2(-h_sharp*wr3);
	
	float fp1 = 1.-fpx;

	float twl3 = max(wl3 - sharp1, 0.0);
	float twl2 = max(wl2 - sharp1, mix(0.0,mix(-0.17, -0.025, fp.x),float(s_sharp > 0.05)));
	float twl1 = max(wl1 - sharp1, 0.0);
	float twr1 = max(wr1 - sharp1, 0.0);	
	float twr2 = max(wr2 - sharp1, mix(0.0,mix(-0.17, -0.025, 1.-fp.x),float(s_sharp > 0.05)));
	float twr3 = max(wr3 - sharp1, 0.0);
	
	float wtt = 1.0/(twl3+twl2+twl1+twr1+twr2+twr3);
	bool sharp = (s_sharp > 0.05);

	pC4 -= dy;
	
	vec3 l3 = texture2D(sampler0, pC4 -x2).xyz; l3*=l3;
	vec3 l2 = texture2D(sampler0, pC4 -dx).xyz; l2*=l2; 
	vec3 l1 = texture2D(sampler0, pC4    ).xyz; l1*=l1;
	vec3 r1 = texture2D(sampler0, pC4 +dx).xyz; r1*=r1;
	vec3 r2 = texture2D(sampler0, pC4 +x2).xyz; r2*=r2;
	vec3 r3 = texture2D(sampler0, pC4 +dx+x2).xyz; r3*=r3;
	
	vec3 color0 = (l3*twl3 + l2*twl2 + l1*twl1 + r1*twr1 + r2*twr2 + r3*twr3)*wtt;
	
	vec3 colmin = min(min(l1,r1), min(l2,r2));
	vec3 colmax = max(max(l1,r1), max(l2,r2));
	
	if (sharp) color0 = clamp(color0, colmin, colmax);
	
	pC4 += dy;
	
	l3 = texture2D(sampler0, pC4 -x2).xyz; l3*=l3;
	l2 = texture2D(sampler0, pC4 -dx).xyz; l2*=l2; 
	l1 = texture2D(sampler0, pC4    ).xyz; l1*=l1;
	r1 = texture2D(sampler0, pC4 +dx).xyz; r1*=r1;
	r2 = texture2D(sampler0, pC4 +x2).xyz; r2*=r2;
	r3 = texture2D(sampler0, pC4 +dx+x2).xyz; r3*=r3;
	
	vec3 color1 = (l3*twl3 + l2*twl2 + l1*twl1 + r1*twr1 + r2*twr2 + r3*twr3)*wtt;
	
	colmin = min(min(l1,r1), min(l2,r2));
	colmax = max(max(l1,r1), max(l2,r2));
	
	if (sharp) color1 = clamp(color1, colmin, colmax);	
	
	pC4 += dy;
	
	l3 = texture2D(sampler0, pC4 -x2).xyz; l3*=l3;
	l2 = texture2D(sampler0, pC4 -dx).xyz; l2*=l2; 
	l1 = texture2D(sampler0, pC4    ).xyz; l1*=l1;
	r1 = texture2D(sampler0, pC4 +dx).xyz; r1*=r1;
	r2 = texture2D(sampler0, pC4 +x2).xyz; r2*=r2;
	r3 = texture2D(sampler0, pC4 +dx+x2).xyz; r3*=r3;
	
	vec3 color2 = (l3*twl3 + l2*twl2 + l1*twl1 + r1*twr1 + r2*twr2 + r3*twr3)*wtt;
	
	colmin = min(min(l1,r1), min(l2,r2));
	colmax = max(max(l1,r1), max(l2,r2));
	
	if (sharp) color2 = clamp(color2, colmin, colmax);	
	
	// calculate bloom color
	
	dx = x2; x2 = dx+dx; dy*=2.0; pC4 -= 1.5*dy;

	l3 = texture2D(sampler0, pC4 -x2).xyz; l3*=l3;
	l2 = texture2D(sampler0, pC4 -dx).xyz; l2*=l2; 
	l1 = texture2D(sampler0, pC4    ).xyz; l1*=l1;
	r1 = texture2D(sampler0, pC4 +dx).xyz; r1*=r1;
	r2 = texture2D(sampler0, pC4 +x2).xyz; r2*=r2;
	r3 = texture2D(sampler0, pC4 +dx+x2).xyz; r3*=r3;
	
	vec3 bcolor0 = (l3*twl3 + l2*twl2 + l1*twl1 + r1*twr1 + r2*twr2 + r3*twr3)*wtt;
	
	pC4 += dy;
	
	l3 = texture2D(sampler0, pC4 -x2).xyz; l3*=l3;
	l2 = texture2D(sampler0, pC4 -dx).xyz; l2*=l2; 
	l1 = texture2D(sampler0, pC4    ).xyz; l1*=l1;
	r1 = texture2D(sampler0, pC4 +dx).xyz; r1*=r1;
	r2 = texture2D(sampler0, pC4 +x2).xyz; r2*=r2;
	r3 = texture2D(sampler0, pC4 +dx+x2).xyz; r3*=r3;
	
	vec3 bcolor1 = (l3*twl3 + l2*twl2 + l1*twl1 + r1*twr1 + r2*twr2 + r3*twr3)*wtt;
	
	pC4 += dy;
	
	l3 = texture2D(sampler0, pC4 -x2).xyz; l3*=l3;
	l2 = texture2D(sampler0, pC4 -dx).xyz; l2*=l2; 
	l1 = texture2D(sampler0, pC4    ).xyz; l1*=l1;
	r1 = texture2D(sampler0, pC4 +dx).xyz; r1*=r1;
	r2 = texture2D(sampler0, pC4 +x2).xyz; r2*=r2;
	r3 = texture2D(sampler0, pC4 +dx+x2).xyz; r3*=r3;
	
	vec3 bcolor2 = (l3*twl3 + l2*twl2 + l1*twl1 + r1*twr1 + r2*twr2 + r3*twr3)*wtt;

	vec3 icolor1 = mix(color1, color0, 0.5);
	vec3 icolor2 = mix(color1, color2, 0.5);
	vec3 color = mix(icolor1, icolor2, f);
	
	vec3 mcolor = pow(color, vec3(0.65));
	
	vec3 b1 = mix(bcolor1, bcolor0, 0.5);
	vec3 b2 = mix(bcolor1, bcolor2, 0.5);
	vec3 Bloom = mix(b1, b2, f);
	
	float pixbr = max(max(color.r, color.g), color.b);
	color*= mix(brightboost1, brightboost2, pixbr);
	color = min(color,1.0);

	vec3 cmask = vec3(1.0); vec3 cmask1 = cmask; vec3 one = vec3(1.0); vec3 orig1 = color;
	
	cmask*= Mask(OGL2bPos,mcolor);
	
	color = color*cmask;
	
	color = min(color,1.0);
	
	cmask1 *= SlotMask(OGL2bPos, mcolor);

	color = color*cmask1; cmask = cmask*cmask1; cmask = min(cmask, 1.0); 
	
	vec3 Bloom1 = 2.0*Bloom*Bloom;
	Bloom1 = min(Bloom1, 0.80);
	float bmax = max(max(Bloom1.r,Bloom1.g),Bloom1.b);
	float pmax = 0.825;
	Bloom1 = min(Bloom1, pmax*bmax)/pmax;
	
	Bloom1 = mix(min( Bloom1, color), Bloom1, 0.5*(orig1+color));
	
	Bloom1 = bloom*Bloom1;
	
	color = color + Bloom1; 	
	
	gl_FragColor.rgb = sqrt(color);
	gl_FragColor.a = 1.0;
}