// Natural Vision Shader, modified to use in PPSSPP.

// by ShadX (Modded by SimoneT)
// http://forums.ngemu.com/showthread.php?t=76098
// Simple Bloom shader; created to use in PPSSPP.
// Without excessive samples and complex nested loops
// (to make it compatible with low-end GPUs and to ensure ps_2_0 compatibility).
// Simple vignette shader - darker towards the corners like in the unprocessed output of a real camera.

#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

uniform sampler2D sampler0;

//Natural
varying vec4 v_texcoord0;
varying vec4 v_texcoord1;
varying vec4 v_texcoord2;
varying vec4 v_texcoord3;

const mat3 RGBtoYIQ = mat3(0.299, 0.596, 0.212, 
                           0.587,-0.275,-0.523, 
                           0.114,-0.321, 0.311);

const mat3 YIQtoRGB = mat3(1.0, 1.0, 1.0,
                           0.95568806036115671171,-0.27158179694405859326,-1.1081773266826619523,
                           0.61985809445637075388,-0.64687381613840131330, 1.7050645599191817149);

const vec3 val00 = vec3( 1.2, 1.2, 1.2);
//To be continued ...

varying vec2 v_texcoord5;	// special (!!!)

float amount = 0.60; // suitable range = 0.00 - 1.00
float power = 0.5; // suitable range = 0.0 - 1.0

void main()
{
  //Natural
  
  vec3 c0,c1;

c0 = texture2D(sampler0,v_texcoord0.xy).xyz;
c0+=(texture2D(sampler0,v_texcoord0.zy).xyz)*0.25;
c0+=(texture2D(sampler0,v_texcoord0.xw).xyz)*0.25;
c0+=(texture2D(sampler0,v_texcoord0.zw).xyz)*0.125;

c0+= texture2D(sampler0,v_texcoord1.xy).xyz;
c0+=(texture2D(sampler0,v_texcoord1.zy).xyz)*0.25;
c0+=(texture2D(sampler0,v_texcoord1.xw).xyz)*0.25;
c0+=(texture2D(sampler0,v_texcoord1.zw).xyz)*0.125;

c0+= texture2D(sampler0,v_texcoord2.xy).xyz;
c0+=(texture2D(sampler0,v_texcoord2.zy).xyz)*0.25;
c0+=(texture2D(sampler0,v_texcoord2.xw).xyz)*0.25;
c0+=(texture2D(sampler0,v_texcoord2.zw).xyz)*0.125;

c0+= texture2D(sampler0,v_texcoord3.xy).xyz;
c0+=(texture2D(sampler0,v_texcoord3.zy).xyz)*0.25;
c0+=(texture2D(sampler0,v_texcoord3.xw).xyz)*0.25;
c0+=(texture2D(sampler0,v_texcoord3.zw).xyz)*0.125;
c0*=0.153846153846;

c1=RGBtoYIQ*c0;

c1=vec3(pow(c1.x,val00.x),c1.yz*val00.yz);

//End

  vec3 color = YIQtoRGB*c1;
  vec4 sum = vec4(0);
  vec3 bloom;
  
  for(int i= -3 ;i < 3; i++)
  {
    sum += texture2D(sampler0, v_texcoord5 + vec2(-1, i)*0.004) * amount;
    sum += texture2D(sampler0, v_texcoord5 + vec2(0, i)*0.004) * amount;
    sum += texture2D(sampler0, v_texcoord5 + vec2(1, i)*0.004) * amount;
  }
      
  if (color.r < 0.3 && color.g < 0.3 && color.b < 0.3)
  {
    bloom = sum.xyz*sum.xyz*0.012 + color;
  }
  else
  {
    if (color.r < 0.5 && color.g < 0.5 && color.b < 0.5)
      {
         bloom = sum.xyz*sum.xyz*0.009 + color;
      }
    else
      {
        bloom = sum.xyz*sum.xyz*0.0075 + color;
      }
  }
  
  bloom = mix(color, bloom, power);
  
  // [Vignette part]
  float vignette = 1.1 - 0.6 * (dot(v_texcoord5 - 0.5, v_texcoord5 - 0.5) * 2.0);
  bloom = vignette * bloom;
  // [end]
  
  gl_FragColor.rgb = bloom;

}
