// Simple Bloom shader; created to use in PPSSPP.
// Without excessive samples and complex nested loops
// (to make it compatible with low-end GPUs and to ensure ps_2_0 compatibility).
// Simple vignette shader - darker towards the corners like in the unprocessed output of a real camera.
// Retro (CRT) shader, created to use in PPSSPP.

#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

uniform sampler2D sampler0;
varying vec2 v_texcoord0;
uniform vec4 u_time;

float amount = 0.60; // suitable range = 0.00 - 1.00
float power = 0.5; // suitable range = 0.0 - 1.0

void main()
{
  vec3 color = texture2D(sampler0, v_texcoord0.xy).xyz;
  vec4 sum = vec4(0);
  vec3 bloom;
  
  for(int i= -3 ;i < 3; i++)
  {
    sum += texture2D(sampler0, v_texcoord0 + vec2(-1, i)*0.004) * amount;
    sum += texture2D(sampler0, v_texcoord0 + vec2(0, i)*0.004) * amount;
    sum += texture2D(sampler0, v_texcoord0 + vec2(1, i)*0.004) * amount;
  }
      
  if (color.r < 0.3 && color.g < 0.3 && color.b < 0.3)
  {
    bloom = sum.xyz*sum.xyz*0.012 + color;
  }
  else
  {
    if (color.r < 0.5 && color.g < 0.5 && color.b < 0.5)
      {
         bloom = sum.xyz*sum.xyz*0.009 + color;
      }
    else
      {
        bloom = sum.xyz*sum.xyz*0.0075 + color;
      }
  }
  
  bloom = mix(color, bloom, power);
  
  // [Vignette part]
  float vignette = 1.1 - 0.6 * (dot(v_texcoord0 - 0.5, v_texcoord0 - 0.5) * 2.0);
  bloom = vignette * bloom;
  // [end]
  
  
  //[Crt part]
  // scanlines
  int vPos = int( ( v_texcoord0.y + u_time.x * 0.5 ) * 272.0 );
  float line_intensity = mod( float(vPos), 2.0 );
    
  // color shift
  float off = line_intensity * 0.0005;
  vec2 shift = vec2( off, 0 );
    
  // shift R and G channels to simulate NTSC color bleed
  vec2 colorShift = vec2( 0.001, 0 );
  float r = bloom.x;
  float g = bloom.y;
  float b = bloom.z;
    
  vec4 c = vec4( r, g * 0.99, b, 1.0 ) * clamp( line_intensity, 0.85, 1.0 );
    
  float rollbar = sin( ( v_texcoord0.y + u_time.x ) * 4.0 );
    
  gl_FragColor.rgba = c + (rollbar * 0.02);
  //[end]

}
