// Simple vignette shader - darker towards the corners like in the unprocessed output of a real camera.
// Retro (CRT) shader, created to use in PPSSPP.

#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

uniform sampler2D sampler0;
varying vec2 v_texcoord0;
uniform vec4 u_time;

void main()
{
  
  // [Vignette part]
  float vignette = 1.1 - 0.6 * (dot(v_texcoord0 - 0.5, v_texcoord0 - 0.5) * 2.0);
  vec3 rgb = texture2D(sampler0, v_texcoord0.xy).xyz;
  rgb = vignette * rgb;
  // [end]
  
  
  //[Crt part]
  // scanlines
  int vPos = int( ( v_texcoord0.y + u_time.x * 0.5 ) * 272.0 );
  float line_intensity = mod( float(vPos), 2.0 );
    
  // color shift
  float off = line_intensity * 0.0005;
  vec2 shift = vec2( off, 0 );
    
  // shift R and G channels to simulate NTSC color bleed
  vec2 colorShift = vec2( 0.001, 0 );
  float r = rgb.x;
  float g = rgb.y;
  float b = rgb.z;
    
  vec4 c = vec4( r, g * 0.99, b, 1.0 ) * clamp( line_intensity, 0.85, 1.0 );
    
  float rollbar = sin( ( v_texcoord0.y + u_time.x ) * 4.0 );
    
  gl_FragColor.rgba = c + (rollbar * 0.02);
  //[end]
  
}
