#!/bin/sh

NOW=$(date +"%m.%d.%Y")

## Start PPSSPPSDL Compile

cd /home/jeremy/Source &&

rm -rf ppsspp

git clone git://github.com/hrydgard/ppsspp.git &&

cd ppsspp && 

git submodule update -i && 

./b.sh ;

cd build &&

strip PPSSPPSDL && 

mkdir /tmp/ppsspp &&

cp -a /home/jeremy/Source/ppsspp/LICENSE.TXT /tmp/ppsspp &&

mv /home/jeremy/Source/ppsspp/build/assets /home/jeremy/Source/ppsspp/build/PPSSPPSDL /tmp/ppsspp &&

cd /tmp &&

tar -cf /tmp/ppsspp-$NOW.tar ppsspp &&

bzip2 -zvf /tmp/ppsspp-$NOW.tar &&

mv /tmp/ppsspp-$NOW.tar.bz2 /home/jeremy/Dropbox/ppsspp &&

rm -rf /tmp/ppsspp*

## Start PPSSPPQT Compile

cd /home/jeremy/Source &&

rm -rf ppsspp

git clone git://github.com/hrydgard/ppsspp.git &&

cd ppsspp && 

git submodule update -i && 

cd /home/jeremy/Source/ppsspp &&

mkdir buildQt &&

cd ~/Source/ppsspp/buildQt/ && 

qmake-qt5 ../Qt/PPSSPPQt.pro && 

make &&

cd /home/jeremy/Source/ppsspp/buildQt && 

strip PPSSPPQt && 

mkdir /tmp/ppsspp &&

cp -a /home/jeremy/Source/ppsspp/LICENSE.TXT /tmp/ppsspp &&

mv /home/jeremy/Source/ppsspp/buildQt/PPSSPPQt /tmp/ppsspp &&

cd /tmp &&

tar -cf /tmp/ppssppQt-$NOW.tar ppsspp &&

bzip2 -zvf /tmp/ppssppQt-$NOW.tar &&

mv /tmp/ppssppQt-$NOW.tar.bz2 /home/jeremy/Dropbox/ppsspp &&

rm -rf /tmp/ppsspp*

